# バッチ設計書 7-Storage Version Migrator

## 概要

本ドキュメントは、ストレージバージョンのマイグレーションを実行するStorage Version Migratorコントローラーの設計を記述する。

### 本バッチの処理概要

Storage Version Migrator（SVMController）は、StorageVersionMigrationリソースに定義されたリソースのストレージバージョンを新しいバージョンへ移行するバッチ処理コントローラーである。Garbage CollectorのGraphBuilderモニターを活用してリソースを列挙し、Server-Side Applyによるパッチ操作でマイグレーションを実行する。

**業務上の目的・背景**：Kubernetes APIリソースのストレージバージョン（etcdに保存される際のバージョン）が変更された場合、既存のオブジェクトは古いバージョンのまま保存されている。Storage Version Migratorは、StorageVersionMigrationリソースをトリガーとして全対象リソースに対してServer-Side Applyパッチを発行し、新しいストレージバージョンでの再書き込みを実現する。これにより、全リソースが統一されたストレージバージョンで保持される。

**バッチの実行タイミング**：StorageVersionMigrationリソースの作成・更新イベントをInformerで監視し、イベント駆動で実行される。

**主要な処理内容**：
1. StorageVersionMigration（SVM）リソースの監視
2. SVMのSpec.Resourceに基づくGVR（GroupVersionResource）解決
3. Garbage CollectorのGraphBuilder経由でリソースモニター取得
4. リソースモニターのキャッシュからオブジェクト一覧を取得
5. ResourceVersionチェックポイントに基づくフィルタリング
6. Server-Side Apply（ApplyPatchType）による各オブジェクトのパッチ
7. SVMステータスの更新（Running/Succeeded/Failed）
8. コンフリクト・リトライアブルエラーのハンドリング

**前後の処理との関連**：Garbage CollectorのGraphBuilderからGetMonitorを通じてリソースモニターを取得する。SVMリソースはkube-apiserverが作成する。

**影響範囲**：マイグレーション対象の全リソース（全Namespace）。StorageVersionMigrationリソース（storagemigration/v1beta1）。

## バッチ種別

データマイグレーション型（ストレージバージョン移行バッチ処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（随時） |
| 実行時刻 | StorageVersionMigration作成時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | StorageVersionMigrationリソースの作成/更新イベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| kube-controller-manager起動 | SVMControllerはkube-controller-manager内で起動 |
| Informerキャッシュ同期完了 | StorageVersionMigrationのInformerキャッシュが同期済み |
| Garbage Collector稼働 | GraphBuilderのモニターが利用可能であること |
| API Server接続 | kube-apiserverと通信可能であること |

### 実行可否判定

SVMリソースのStatus.ResourceVersionが設定されていること。SVMのステータスがSucceededまたはFailedでないこと。Garbage Collectorのキャッシュが最新であること（ResourceVersion比較）。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| workers | int（定数） | No | 5 | ワーカーの並列数 |
| controllerName | string | Yes | なし | コントローラー名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| StorageVersionMigration Informer | Kubernetes API (storagemigration/v1beta1) | SVMリソースの変更イベント監視 |
| GC GraphBuilder Monitor | In-memory | リソースモニターのキャッシュ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 対象リソース（パッチ） | Kubernetes API (dynamic) | Server-Side Applyパッチ |
| SVM Status更新 | Kubernetes API (storagemigration/v1beta1) | Running/Succeeded/Failedステータス |

### 出力ファイル仕様

ファイル出力はなし。

## 処理フロー

### 処理シーケンス

```
1. コントローラー初期化（NewSVMController）
   └─ Informer登録、workqueue作成、restMapper/graphBuilder設定
2. Run起動
   └─ キャッシュ同期待ち、5ワーカー起動
3. sync処理
   ├─ SVMリソース取得
   ├─ 既にSucceeded/Failedならスキップ
   ├─ Status.ResourceVersionが空ならスキップ
   ├─ GVR解決（restMapper使用）
   ├─ GraphBuilderからモニター取得（10秒タイムアウト）
   ├─ GCキャッシュのResourceVersion比較
   ├─ SVMステータスをRunningに更新
   └─ runMigration実行
4. runMigration処理
   ├─ モニターストアから全オブジェクト列挙
   ├─ ResourceVersionフィルタリング
   ├─ Server-Side Applyパッチ（TypeMeta + UID + RV）
   ├─ コンフリクト → スキップ
   ├─ リトライアブルエラー → リキュー
   └─ 完了 → Succeededステータス更新
```

### フローチャート

```mermaid
flowchart TD
    A[SVMイベント受信] --> B[SVM取得]
    B --> C{Succeeded/Failed?}
    C -->|Yes| D[スキップ]
    C -->|No| E{ResourceVersion設定済み?}
    E -->|No| D
    E -->|Yes| F[GVR解決]
    F --> G[GCモニター取得]
    G --> H{GCキャッシュ最新?}
    H -->|No| I[リキュー]
    H -->|Yes| J[Running状態に更新]
    J --> K[全オブジェクト列挙]
    K --> L[Server-Side Applyパッチ]
    L --> M{エラー?}
    M -->|コンフリクト| N[スキップ]
    M -->|リトライアブル| I
    M -->|致命的| O[Failed状態に更新]
    M -->|なし| P[Succeeded状態に更新]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| SVM取得 | etcd (storageversionmigrations) | SELECT | Lister経由 |
| SVM Status更新 | etcd (storageversionmigrations) | UPDATE | Running/Succeeded/Failed |
| リソースパッチ | etcd (対象リソース) | PATCH | Server-Side Apply |

### テーブル別操作詳細

#### 対象リソース (dynamic)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| PATCH | TypeMeta, UID, ResourceVersion | Server-Side Apply | ApplyPatchType使用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | SVM NotFound | SVMが削除済み | 処理スキップ |
| - | GVR解決失敗 | 無効なリソース指定 | 1分待機後にFailed |
| - | GCモニター未同期 | GCキャッシュが古い | リキュー |
| - | Conflict | リソースが更新/削除済み | スキップ（マイグレーション不要） |
| - | リトライアブルエラー | サーバースロットリング等 | SuggestsClientDelay考慮でリキュー |
| - | 致命的エラー | パッチ適用失敗 | Failedステータスに更新 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（レートリミッター制御） |
| リトライ間隔 | TypedRateLimitingQueue + SuggestsClientDelay |
| リトライ対象エラー | 接続リセット、HTTP2接続断、ServerTimeout、TooManyRequests、ServiceUnavailable、InternalError、Timeout |

### 障害時対応

マイグレーションが失敗した場合はSVMステータスをFailedに更新する。コンフリクトエラーは正常扱い（リソースが既に更新/削除されているため、マイグレーション不要）。リトライアブルエラーは自動リキューされる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | リソース単位（各オブジェクト個別にパッチ） |
| コミットタイミング | 各パッチAPIコール時 |
| ロールバック条件 | パッチ失敗時はエラーハンドリングに従う |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 対象リソースの総オブジェクト数 |
| 目標処理時間 | リソースタイプとオブジェクト数に依存 |
| メモリ使用量上限 | GCモニターキャッシュサイズに依存 |

## 排他制御

- workqueueによるキー単位の排他制御
- Server-Side Applyによるコンフリクト検出（UID + ResourceVersionによる楽観的排他）
- GCモニタータイムアウト（10秒）による同期待ちの制限

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | コントローラー起動時 | "Starting {controllerName}" |
| 進捗ログ | マイグレーション完了時（V4） | "Finished syncing svm resource" |
| 終了ログ | コントローラー停止時 | "Shutting down {controllerName}" |
| エラーログ | パッチ失敗時 | "Failed to migrate the resource" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| workqueue深さ | メトリクス（Prometheusで監視） | クラスタ管理者 |
| SVM Failed状態 | SVMリソースのステータス | クラスタ管理者 |

## 備考

- ソースコード: `pkg/controller/storageversionmigrator/storageversionmigrator.go`
- workers定数 = 5
- ステータス理由: StorageVersionMigrationSucceeded / StorageVersionMigrationInProgress / StorageVersionMigrationFailed
- SVMはクラスタスコープリソース
- isRetriableError: 接続リセット、HTTP2接続断、EOF、ServerTimeout、TooManyRequests、ServiceUnavailable、InternalError、Timeout
- typeMetaUIDRV構造体: TypeMeta + UID + ResourceVersionのみをマーシャルしてパッチ送信
